/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.abilities.Ability;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.TransformSourceEffect;
import mage.cards.Card;
import mage.cards.v.VoltaicVisionaryWatcher;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;

class VoltaicVisionaryTriggeredAbility
extends TriggeredAbilityImpl {
    VoltaicVisionaryTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new TransformSourceEffect());
        this.addWatcher(new VoltaicVisionaryWatcher());
        this.setTriggerPhrase("When you play a card exiled with {this}, ");
    }

    private VoltaicVisionaryTriggeredAbility(VoltaicVisionaryTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public VoltaicVisionaryTriggeredAbility copy() {
        return new VoltaicVisionaryTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST || event.getType() == GameEvent.EventType.LAND_PLAYED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!this.isControlledBy(event.getPlayerId())) {
            return false;
        }
        Card card = game.getCard(event.getSourceId());
        if (card == null) {
            return false;
        }
        return VoltaicVisionaryWatcher.checkCard(card, (Ability)this, game);
    }
}

