/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.ArrayList;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.FoodToken;
import mage.game.permanent.token.Token;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetSacrifice;

class VoraciousFellBeastEffect
extends OneShotEffect {
    VoraciousFellBeastEffect() {
        super(Outcome.Sacrifice);
        this.staticText = "each opponent sacrifices a creature. Create a Food token for each creature sacrificed this way";
    }

    private VoraciousFellBeastEffect(VoraciousFellBeastEffect effect) {
        super((OneShotEffect)effect);
    }

    public VoraciousFellBeastEffect copy() {
        return new VoraciousFellBeastEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        ArrayList perms = new ArrayList();
        for (UUID playerId : game.getOpponents(controller.getId())) {
            TargetSacrifice target;
            Player player = game.getPlayer(playerId);
            if (player == null || !(target = new TargetSacrifice((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE)).canChoose(player.getId(), source, game)) continue;
            while (!target.isChosen(game) && player.canRespond()) {
                player.choose(Outcome.Sacrifice, (Target)target, source, game);
            }
            perms.addAll(target.getTargets());
        }
        int sacrificeCount = 0;
        for (UUID permID : perms) {
            Permanent permanent = game.getPermanent(permID);
            if (permanent == null || !permanent.sacrifice(source, game)) continue;
            ++sacrificeCount;
        }
        if (sacrificeCount > 0) {
            game.processAction();
            new CreateTokenEffect((Token)new FoodToken(), sacrificeCount).apply(game, source);
        }
        return true;
    }
}

