/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.abilities.Ability;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.keyword.DeathtouchAbility;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.AbilityPredicate;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class VraskaSwarmsEminenceTriggeredAbility
extends TriggeredAbilityImpl {
    private static final FilterPermanent filter = new FilterControlledCreaturePermanent("creature you control with deathtouch");

    public VraskaSwarmsEminenceTriggeredAbility(Zone zone, Effect effect) {
        super(zone, effect, false);
        this.setTriggerPhrase("Whenever a creature you control with deathtouch deals damage to a player or planeswalker, ");
    }

    private VraskaSwarmsEminenceTriggeredAbility(VraskaSwarmsEminenceTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public VraskaSwarmsEminenceTriggeredAbility copy() {
        return new VraskaSwarmsEminenceTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PLAYER || event.getType() == GameEvent.EventType.DAMAGED_PERMANENT;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent = game.getPermanent(event.getSourceId());
        if (permanent == null || !filter.match(permanent, this.getControllerId(), (Ability)this, game)) {
            return false;
        }
        Permanent damaged = game.getPermanentOrLKIBattlefield(event.getTargetId());
        if (damaged != null && !damaged.isPlaneswalker(game)) {
            return false;
        }
        this.getEffects().setValue("damage", (Object)event.getAmount());
        this.getEffects().setValue("sourceId", (Object)event.getSourceId());
        this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(permanent.getId(), permanent.getZoneChangeCounter(game)));
        return true;
    }

    static {
        filter.add((Predicate)new AbilityPredicate(DeathtouchAbility.class));
    }
}

