/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.TappedPredicate;
import mage.game.Game;
import mage.game.permanent.token.GreenCatToken;
import mage.players.Player;

class WaitingInTheWeedsEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterPermanent("untapped Forest they control");

    public WaitingInTheWeedsEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Each player creates a 1/1 green Cat creature token for each untapped Forest they control";
    }

    private WaitingInTheWeedsEffect(WaitingInTheWeedsEffect effect) {
        super((OneShotEffect)effect);
    }

    public WaitingInTheWeedsEffect copy() {
        return new WaitingInTheWeedsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                GreenCatToken token = new GreenCatToken();
                int amount = game.getBattlefield().getAllActivePermanents(filter, playerId, game).size();
                token.putOntoBattlefield(amount, game, source, playerId);
            }
            return true;
        }
        return false;
    }

    static {
        filter.add((Predicate)SubType.FOREST.getPredicate());
        filter.add((Predicate)TappedPredicate.UNTAPPED);
    }
}

