/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

class WaltzOfRageEffect
extends OneShotEffect {
    WaltzOfRageEffect() {
        super(Outcome.Benefit);
        this.staticText = "target creature you control deals damage equal to its power to each other creature";
    }

    private WaltzOfRageEffect(WaltzOfRageEffect effect) {
        super((OneShotEffect)effect);
    }

    public WaltzOfRageEffect copy() {
        return new WaltzOfRageEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            return false;
        }
        int power = permanent.getPower().getValue();
        if (power < 1) {
            return false;
        }
        for (Permanent creature : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getControllerId(), source, game)) {
            if (creature.getId().equals(permanent.getId())) continue;
            creature.damage(power, permanent.getId(), source, game);
        }
        return true;
    }
}

