/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class WandOfDenialEffect
extends OneShotEffect {
    WandOfDenialEffect() {
        super(Outcome.Benefit);
        this.staticText = "Look at the top card of target player's library. If it's a nonland card, you may pay 2 life. If you do, put it into that player's graveyard.";
    }

    private WandOfDenialEffect(WandOfDenialEffect effect) {
        super((OneShotEffect)effect);
    }

    public WandOfDenialEffect copy() {
        return new WandOfDenialEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card;
        Player controller = game.getPlayer(source.getControllerId());
        Player targetPlayer = game.getPlayer(source.getFirstTarget());
        if (controller != null && targetPlayer != null && (card = targetPlayer.getLibrary().getFromTop(game)) != null) {
            MageObject sourceObject = game.getObject(source);
            controller.lookAtCards(sourceObject != null ? sourceObject.getName() : "", (Cards)new CardsImpl(card), game);
            if (!card.isLand(game) && controller.canPayLifeCost(source) && controller.getLife() >= 2 && controller.chooseUse(Outcome.Neutral, "Pay 2 life to put " + card.getLogName() + " into graveyard?", source, game)) {
                controller.loseLife(2, game, source, false);
                controller.moveCards(card, Zone.GRAVEYARD, source, game);
            }
            return true;
        }
        return false;
    }
}

