/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class WandOfWonderEffect
extends OneShotEffect {
    private final int xValue;

    WandOfWonderEffect(int xValue) {
        super(Outcome.Benefit);
        this.staticText = "X is " + CardUtil.numberToText((int)xValue);
        this.xValue = xValue;
    }

    private WandOfWonderEffect(WandOfWonderEffect effect) {
        super((OneShotEffect)effect);
        this.xValue = effect.xValue;
    }

    public WandOfWonderEffect copy() {
        return new WandOfWonderEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        CardsImpl toCast = new CardsImpl();
        for (UUID playerId : game.getOpponents(controller.getId())) {
            Player opponent = game.getPlayer(playerId);
            if (opponent == null) continue;
            for (Card card : opponent.getLibrary().getCards(game)) {
                opponent.moveCards(card, Zone.EXILED, source, game);
                if (card.isInstantOrSorcery(game)) {
                    toCast.add(card);
                    break;
                }
                cards.add(card);
            }
            opponent.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
            opponent.shuffleLibrary(source, game);
            cards.clear();
        }
        CardUtil.castMultipleWithAttributeForFree((Player)controller, (Ability)source, (Game)game, (Cards)toCast, (FilterCard)StaticFilters.FILTER_CARD_INSTANT_OR_SORCERY, (int)this.xValue);
        return true;
    }
}

