/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.permanent.Permanent;

class WarFalconEffect
extends RestrictionEffect {
    private static final FilterControlledPermanent filter = new FilterControlledPermanent("Knight or a Soldier");

    public WarFalconEffect() {
        super(Duration.WhileOnBattlefield);
        this.staticText = "{this} can't attack unless you control a Knight or a Soldier";
    }

    private WarFalconEffect(WarFalconEffect effect) {
        super((RestrictionEffect)effect);
    }

    public WarFalconEffect copy() {
        return new WarFalconEffect(this);
    }

    public boolean canAttack(Game game, boolean canUseChooseDialogs) {
        return false;
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        if (permanent.getId().equals(source.getSourceId())) {
            return game.getBattlefield().countAll((FilterPermanent)filter, source.getControllerId(), game) <= 0;
        }
        return false;
    }

    static {
        filter.add(Predicates.or((Predicate)SubType.KNIGHT.getPredicate(), (Predicate)SubType.SOLDIER.getPredicate()));
    }
}

