/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class WarbriarBlessingEffect
extends OneShotEffect {
    WarbriarBlessingEffect() {
        super(Outcome.Benefit);
        this.staticText = "enchanted creature fights up to one target creature you don't control. <i>(Each deals damage equal to its power to the other.)</i>";
    }

    private WarbriarBlessingEffect(WarbriarBlessingEffect effect) {
        super((OneShotEffect)effect);
    }

    public WarbriarBlessingEffect copy() {
        return new WarbriarBlessingEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        Permanent opponentsPermanent = game.getPermanent(source.getFirstTarget());
        if (permanent == null || opponentsPermanent == null) {
            return false;
        }
        Permanent attach = game.getPermanent(permanent.getAttachedTo());
        if (attach == null) {
            return false;
        }
        return attach.fight(opponentsPermanent, source, game);
    }
}

