/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.AddCardSubTypeSourceEffect;
import mage.abilities.effects.common.continuous.GainAbilitySourceEffect;
import mage.abilities.keyword.LifelinkAbility;
import mage.abilities.keyword.TrampleAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class WardenOfTheFirstTreeEffect
extends OneShotEffect {
    WardenOfTheFirstTreeEffect() {
        super(Outcome.Benefit);
        this.staticText = "if {this} is a Warrior, it becomes a Human Spirit Warrior with trample and lifelink";
    }

    private WardenOfTheFirstTreeEffect(WardenOfTheFirstTreeEffect effect) {
        super((OneShotEffect)effect);
    }

    public WardenOfTheFirstTreeEffect copy() {
        return new WardenOfTheFirstTreeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent == null || !permanent.hasSubtype(SubType.WARRIOR, game)) {
            return false;
        }
        game.addEffect((ContinuousEffect)new AddCardSubTypeSourceEffect(Duration.Custom, new SubType[]{SubType.HUMAN, SubType.SPIRIT, SubType.WARRIOR}), source);
        game.addEffect((ContinuousEffect)new GainAbilitySourceEffect((Ability)TrampleAbility.getInstance(), Duration.Custom), source);
        game.addEffect((ContinuousEffect)new GainAbilitySourceEffect((Ability)LifelinkAbility.getInstance(), Duration.Custom), source);
        return true;
    }
}

