/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.discard.DiscardTargetEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class WarpedDevotionTriggeredAbility
extends TriggeredAbilityImpl {
    public WarpedDevotionTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DiscardTargetEffect(1), false);
    }

    private WarpedDevotionTriggeredAbility(WarpedDevotionTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public WarpedDevotionTriggeredAbility copy() {
        return new WarpedDevotionTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeEvent zce = (ZoneChangeEvent)event;
        if (zce.getFromZone() == Zone.BATTLEFIELD && zce.getToZone() == Zone.HAND) {
            for (Effect effect : this.getEffects()) {
                effect.setTargetPointer((TargetPointer)new FixedTarget(zce.getTarget().getOwnerId()));
            }
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever a permanent is returned to a player's hand, that player discards a card.";
    }
}

