/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class WarsTollAttackRestrictionEffect
extends RestrictionEffect {
    WarsTollAttackRestrictionEffect() {
        super(Duration.WhileOnBattlefield);
        this.staticText = "If a creature an opponent controls attacks, all creatures that opponent controls attack if able";
    }

    private WarsTollAttackRestrictionEffect(WarsTollAttackRestrictionEffect effect) {
        super((RestrictionEffect)effect);
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        Player controller = game.getPlayer(permanent.getControllerId());
        if (controller != null) {
            return controller.hasOpponent(source.getControllerId(), game);
        }
        return false;
    }

    public boolean canAttackCheckAfter(int numberOfAttackers, Ability source, Game game, boolean canUseChooseDialogs) {
        if (numberOfAttackers == 0) {
            return true;
        }
        for (Permanent creaturePermanent : game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURES, game.getActivePlayerId(), game)) {
            if (!creaturePermanent.canAttack(null, game) || creaturePermanent.isAttacking()) continue;
            return false;
        }
        return true;
    }

    public WarsTollAttackRestrictionEffect copy() {
        return new WarsTollAttackRestrictionEffect(this);
    }
}

