/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.LinkedHashSet;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.choices.Choice;
import mage.choices.ChoiceColor;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class WashOutEffect
extends OneShotEffect {
    WashOutEffect() {
        super(Outcome.ReturnToHand);
        this.staticText = "Return all permanents of the color of your choice to their owners' hands";
    }

    private WashOutEffect(WashOutEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        LinkedHashSet<Permanent> cardsToReturn = new LinkedHashSet<Permanent>();
        ChoiceColor choice = new ChoiceColor();
        if (controller != null && controller.choose(Outcome.ReturnToHand, (Choice)choice, game)) {
            ObjectColor color = choice.getColor();
            FilterPermanent filter = new FilterPermanent();
            filter.add((Predicate)new ColorPredicate(color));
            for (Permanent permanent : game.getBattlefield().getActivePermanents(filter, source.getControllerId(), source, game)) {
                cardsToReturn.add(permanent);
            }
            return controller.moveCards(cardsToReturn, Zone.HAND, source, game);
        }
        return false;
    }

    public WashOutEffect copy() {
        return new WashOutEffect(this);
    }
}

