/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.condition.common.KickedCondition;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.token.RogueToken;
import mage.players.Player;

class WasteManagementEffect
extends OneShotEffect {
    WasteManagementEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile up to two target cards from a single graveyard. If this spell was kicked, instead exile target player's graveyard. Create a 2/2 black Rogue creature token for each creature card exiled this way";
    }

    private WasteManagementEffect(WasteManagementEffect effect) {
        super((OneShotEffect)effect);
    }

    public WasteManagementEffect copy() {
        return new WasteManagementEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        if (KickedCondition.ONCE.apply(game, source)) {
            Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
            if (player != null) {
                cards.addAll((Collection)player.getGraveyard());
            }
        } else {
            cards.addAll((Collection)this.getTargetPointer().getTargets(game, source));
        }
        if (cards.isEmpty()) {
            return false;
        }
        controller.moveCards((Cards)cards, Zone.EXILED, source, game);
        cards.retainZone(Zone.EXILED, game);
        int count = cards.count((FilterCard)StaticFilters.FILTER_CARD_CREATURE, game);
        if (count > 0) {
            game.processAction();
            new RogueToken().putOntoBattlefield(count, game, source);
        }
        return true;
    }
}

