/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class WateryGraspEffect
extends OneShotEffect {
    WateryGraspEffect() {
        super(Outcome.Benefit);
        this.staticText = "enchanted creature's owner shuffles it into their library";
    }

    private WateryGraspEffect(WateryGraspEffect effect) {
        super((OneShotEffect)effect);
    }

    public WateryGraspEffect copy() {
        return new WateryGraspEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = Optional.ofNullable(source.getSourcePermanentOrLKI(game)).map(Permanent::getAttachedTo).map(arg_0 -> ((Game)game).getPermanent(arg_0)).orElse(null);
        if (permanent == null) {
            return false;
        }
        Player player = game.getPlayer(permanent.getOwnerId());
        return player != null && player.shuffleCardsToLibrary((Card)permanent, game, source);
    }
}

