/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class WaveOfReckoningDamageEffect
extends OneShotEffect {
    WaveOfReckoningDamageEffect() {
        super(Outcome.Detriment);
        this.staticText = "each creature deals damage to itself equal to its power";
    }

    private WaveOfReckoningDamageEffect(WaveOfReckoningDamageEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        FilterPermanent filter = new FilterPermanent();
        filter.add((Predicate)CardType.CREATURE.getPredicate());
        for (Permanent permanent : game.getBattlefield().getActivePermanents(filter, source.getControllerId(), source, game)) {
            int amount = permanent.getPower().getValue();
            permanent.damage(amount, permanent.getId(), source, game, false, true);
        }
        return true;
    }

    public WaveOfReckoningDamageEffect copy() {
        return new WaveOfReckoningDamageEffect(this);
    }
}

