/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;

class WeatheredRunestoneEffect
extends ContinuousRuleModifyingEffectImpl {
    WeatheredRunestoneEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "Nonland permanent cards in graveyards and libraries can't enter the battlefield";
    }

    private WeatheredRunestoneEffect(WeatheredRunestoneEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public WeatheredRunestoneEffect copy() {
        return new WeatheredRunestoneEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return GameEvent.EventType.ZONE_CHANGE == event.getType();
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        if (zEvent.getToZone() == Zone.BATTLEFIELD && (zEvent.getFromZone() == Zone.GRAVEYARD || zEvent.getFromZone() == Zone.LIBRARY)) {
            Card card = game.getCard(zEvent.getTargetId());
            return card != null && !card.isLand(game) && card.isPermanent(game);
        }
        return false;
    }
}

