/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;

class WeatheredRunestoneEffect2
extends ContinuousRuleModifyingEffectImpl {
    public WeatheredRunestoneEffect2() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "Players can't cast spells from graveyards or libraries";
    }

    private WeatheredRunestoneEffect2(WeatheredRunestoneEffect2 effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public WeatheredRunestoneEffect2 copy() {
        return new WeatheredRunestoneEffect2(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CAST_SPELL;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Card card = game.getCard(event.getSourceId());
        if (card != null) {
            Zone zone = game.getState().getZone(card.getId());
            return zone == Zone.GRAVEYARD || zone == Zone.LIBRARY;
        }
        return false;
    }
}

