/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.cards.w.WeatheredSentinelsLastTurnAttackersWatcher;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;

class WeatheredSentinelsAttackerReplacementEffect
extends ReplacementEffectImpl {
    WeatheredSentinelsAttackerReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
    }

    private WeatheredSentinelsAttackerReplacementEffect(WeatheredSentinelsAttackerReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        return true;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DECLARE_ATTACKER;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Player defender;
        Player controller = game.getPlayer(source.getControllerId());
        Player attacker = game.getPlayer(event.getPlayerId());
        if (controller == null || attacker == null) {
            return false;
        }
        if (!attacker.equals(controller)) {
            return false;
        }
        if (game.getPlayer(event.getTargetId()) != null) {
            defender = game.getPlayer(event.getTargetId());
        } else {
            Permanent planeswalker = game.getPermanent(event.getTargetId());
            Player player = defender = planeswalker == null ? null : game.getPlayer(planeswalker.getControllerId());
        }
        if (defender == null) {
            return false;
        }
        WeatheredSentinelsLastTurnAttackersWatcher watcher = (WeatheredSentinelsLastTurnAttackersWatcher)game.getState().getWatcher(WeatheredSentinelsLastTurnAttackersWatcher.class);
        if (watcher == null) {
            return false;
        }
        return watcher.checkPlayer(defender.getId(), attacker.getId());
    }

    public WeatheredSentinelsAttackerReplacementEffect copy() {
        return new WeatheredSentinelsAttackerReplacementEffect(this);
    }
}

