/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.CardType;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;

class WeepingAngelMarbleizeEffect
extends ContinuousEffectImpl {
    WeepingAngelMarbleizeEffect() {
        super(Duration.EndOfTurn, Layer.TypeChangingEffects_4, SubLayer.NA, Outcome.Detriment);
        this.staticText = "{this} isn't a creature until end of turn.";
        this.dependencyTypes.add(DependencyType.BecomeCreature);
    }

    private WeepingAngelMarbleizeEffect(WeepingAngelMarbleizeEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public WeepingAngelMarbleizeEffect copy() {
        return new WeepingAngelMarbleizeEffect(this);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        if (this.duration.isOnlyValidIfNoZoneChange() && source.getSourcePermanentIfItStillExists(game) == null) {
            this.discard();
        }
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent == null) {
            return false;
        }
        permanent.removeCardType(game, new CardType[]{CardType.CREATURE});
        if (!permanent.isKindred(game)) {
            permanent.removeAllCreatureTypes(game);
        }
        if (permanent.isAttacking() || permanent.getBlocking() > 0) {
            permanent.removeFromCombat(game);
        }
        return true;
    }
}

