/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class WeiAssassinsEffect
extends OneShotEffect {
    WeiAssassinsEffect() {
        super(Outcome.Benefit);
        this.staticText = "target opponent chooses a creature they control. Destroy it.";
    }

    private WeiAssassinsEffect(WeiAssassinsEffect effect) {
        super((OneShotEffect)effect);
    }

    public WeiAssassinsEffect copy() {
        return new WeiAssassinsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent;
        Player player = game.getPlayer(source.getFirstTarget());
        if (player == null) {
            return false;
        }
        FilterCreaturePermanent filter = new FilterCreaturePermanent("creature you control");
        filter.add((Predicate)new ControllerIdPredicate(player.getId()));
        TargetPermanent target = new TargetPermanent(1, 1, (FilterPermanent)filter, true);
        if (player.chooseTarget(Outcome.DestroyPermanent, (Target)target, source, game) && (permanent = game.getPermanent(target.getFirstTarget())) != null) {
            permanent.destroy(source, game, false);
        }
        return true;
    }
}

