/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainControlTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class WellspringEffect
extends OneShotEffect {
    WellspringEffect(String text) {
        super(Outcome.Benefit);
        this.staticText = text;
    }

    private WellspringEffect(WellspringEffect effect) {
        super((OneShotEffect)effect);
    }

    public WellspringEffect copy() {
        return new WellspringEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (permanent == null) {
            return false;
        }
        GainControlTargetEffect effect = new GainControlTargetEffect(Duration.EndOfTurn);
        effect.setTargetPointer((TargetPointer)new FixedTarget(permanent.getAttachedTo(), game));
        game.addEffect((ContinuousEffect)effect, source);
        return true;
    }
}

