/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class WheelOfTortureEffect
extends OneShotEffect {
    WheelOfTortureEffect() {
        super(Outcome.Damage);
        this.staticText = "{this} deals X damage to that player, where X is 3 minus the number of cards in their hand";
    }

    private WheelOfTortureEffect(WheelOfTortureEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        int amount;
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player != null && (amount = 3 - player.getHand().size()) > 0) {
            player.damage(amount, source.getSourceId(), source, game);
            return true;
        }
        return false;
    }

    public WheelOfTortureEffect copy() {
        return new WheelOfTortureEffect(this);
    }
}

