/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInLibrary;

class WhiskervaleForerunnerEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCreatureCard("creature card with mana value 3 or less");

    WhiskervaleForerunnerEffect() {
        super(Outcome.Benefit);
        this.staticText = "look at the top five cards of your library. You may reveal a creature card with mana value 3 or less from among them. You may put it onto the battlefield if it's your turn. If you don't put it onto the battlefield, put it into your hand. Put the rest on the bottom of your library in a random order";
    }

    private WhiskervaleForerunnerEffect(WhiskervaleForerunnerEffect effect) {
        super((OneShotEffect)effect);
    }

    public WhiskervaleForerunnerEffect copy() {
        return new WhiskervaleForerunnerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, 5));
        TargetCardInLibrary target = new TargetCardInLibrary(filter);
        player.choose(this.outcome, (Cards)cards, (TargetCard)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        if (card == null) {
            player.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
            return true;
        }
        player.revealCards(source, (Cards)new CardsImpl(card), game);
        if (game.isActivePlayer(player.getId()) && player.chooseUse(Outcome.PutCreatureInPlay, "Put " + card.getName() + " onto the battlefield?", source, game)) {
            player.moveCards(card, Zone.BATTLEFIELD, source, game);
        }
        if (game.getState().getZone(card.getId()) == Zone.LIBRARY) {
            player.moveCards(card, Zone.HAND, source, game);
        }
        cards.retainZone(Zone.LIBRARY, game);
        player.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
        return true;
    }

    static {
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, 4));
    }
}

