/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.players.Player;

class WhisperingSpecterEffect
extends OneShotEffect {
    WhisperingSpecterEffect() {
        super(Outcome.Discard);
        this.staticText = "that player discards a card for each poison counter they have";
    }

    private WhisperingSpecterEffect(WhisperingSpecterEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        int value;
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player != null && (value = player.getCountersCount(CounterType.POISON)) > 0) {
            player.discard(value, false, false, source, game);
            return true;
        }
        return false;
    }

    public WhisperingSpecterEffect copy() {
        return new WhisperingSpecterEffect(this);
    }
}

