/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class WickedGuardianEffect
extends OneShotEffect {
    WickedGuardianEffect() {
        super(Outcome.Benefit);
        this.staticText = "have it deal 2 damage to another creature you control. If you do, draw a card";
    }

    private WickedGuardianEffect(WickedGuardianEffect effect) {
        super((OneShotEffect)effect);
    }

    public WickedGuardianEffect copy() {
        return new WickedGuardianEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        if (game.getBattlefield().count((FilterPermanent)StaticFilters.FILTER_ANOTHER_CREATURE_YOU_CONTROL, source.getControllerId(), source, game) == 0) {
            return false;
        }
        TargetPermanent target = new TargetPermanent(0, 1, (FilterPermanent)StaticFilters.FILTER_ANOTHER_CREATURE_YOU_CONTROL, true);
        if (!player.choose(this.outcome, (Target)target, source, game)) {
            return false;
        }
        Permanent permanent = game.getPermanent(target.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        permanent.damage(2, source.getSourceId(), source, game);
        return player.drawCards(1, source, game) > 0;
    }
}

