/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.UUID;
import mage.MageIdentifier;
import mage.abilities.Ability;
import mage.abilities.costs.Costs;
import mage.abilities.costs.CostsImpl;
import mage.abilities.costs.common.PayLifeCost;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.costs.mana.ManaCosts;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class WickerfolkIndomitableGraveyardEffect
extends AsThoughEffectImpl {
    WickerfolkIndomitableGraveyardEffect() {
        super(AsThoughEffectType.CAST_FROM_NOT_OWN_HAND_ZONE, Duration.EndOfGame, Outcome.PutCreatureInPlay);
        this.staticText = "You may cast this card from your graveyard by paying 2 life and sacrificing an artifact or creature in addition to paying its other costs.";
    }

    private WickerfolkIndomitableGraveyardEffect(WickerfolkIndomitableGraveyardEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public WickerfolkIndomitableGraveyardEffect copy() {
        return new WickerfolkIndomitableGraveyardEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        if (!objectId.equals(source.getSourceId()) || !source.isControlledBy(affectedControllerId) || game.getState().getZone(source.getSourceId()) != Zone.GRAVEYARD) {
            return false;
        }
        Player controller = game.getPlayer(affectedControllerId);
        if (controller != null) {
            CostsImpl costs = new CostsImpl();
            costs.add((Object)new PayLifeCost(2));
            costs.add((Object)new SacrificeTargetCost((FilterPermanent)StaticFilters.FILTER_CONTROLLED_PERMANENT_ARTIFACT_OR_CREATURE));
            controller.setCastSourceIdWithAlternateMana(objectId, (ManaCosts)new ManaCostsImpl("{3}{B}"), (Costs)costs, MageIdentifier.WickerfolkIndomitableAlternateCast);
            return true;
        }
        return false;
    }
}

