/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.token.BeastToken;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class WildEndeavorEffect
extends OneShotEffect {
    WildEndeavorEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "Roll two d4 and choose one result. Create a number of 3/3 green Beast creature tokens equal to that result. Then search your library for a number of basic land cards equal to the other result, put them onto the battlefield tapped, then shuffle.";
    }

    private WildEndeavorEffect(WildEndeavorEffect effect) {
        super((OneShotEffect)effect);
    }

    public WildEndeavorEffect copy() {
        return new WildEndeavorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int second;
        int first;
        int secondResult;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        List results = controller.rollDice(this.outcome, source, game, 4, 2, 0);
        int firstResult = (Integer)results.get(0);
        if (firstResult != (secondResult = ((Integer)results.get(1)).intValue()) && controller.chooseUse(this.outcome, "Choose the amount of 3/3 green Beast creature tokens.", "The other number is the amount of basic lands you search from your library and put on the battlefield tapped.", "" + firstResult, "" + secondResult, source, game)) {
            first = firstResult;
            second = secondResult;
        } else {
            first = secondResult;
            second = firstResult;
        }
        new BeastToken().putOntoBattlefield(first, game, source, source.getControllerId());
        TargetCardInLibrary target = new TargetCardInLibrary(0, second, (FilterCard)StaticFilters.FILTER_CARD_BASIC_LAND);
        controller.searchLibrary(target, source, game);
        Set cards = target.getTargets().stream().map(arg_0 -> ((Game)game).getCard(arg_0)).filter(Objects::nonNull).collect(Collectors.toSet());
        controller.moveCards(cards, Zone.BATTLEFIELD, source, game, true, false, false, null);
        controller.shuffleLibrary(source, game);
        return true;
    }
}

