/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.ApprovingObject;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.util.GameLog;

class WildEvocationEffect
extends OneShotEffect {
    WildEvocationEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "that player reveals a card at random from their hand. If it's a land card, the player puts it onto the battlefield. Otherwise, the player casts it without paying its mana cost if able";
    }

    private WildEvocationEffect(WildEvocationEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        MageObject sourceObject = source.getSourceObject(game);
        if (player != null && sourceObject != null) {
            Card card = player.getHand().getRandom(game);
            if (card != null) {
                CardsImpl cards = new CardsImpl(card);
                player.revealCards(sourceObject.getIdName() + " Turn: " + game.getTurnNum(), (Cards)cards, game);
                if (card.isLand(game)) {
                    player.moveCards(card, Zone.BATTLEFIELD, source, game);
                } else if (card.getSpellAbility() != null) {
                    game.getState().setValue("PlayFromNotOwnHandZone" + card.getId(), (Object)Boolean.TRUE);
                    player.cast(player.chooseAbilityForCast(card, game, true), game, true, new ApprovingObject(source, game));
                    game.getState().setValue("PlayFromNotOwnHandZone" + card.getId(), null);
                } else {
                    game.informPlayers(GameLog.getColoredObjectName((MageObject)card) + " can't be cast now by " + player.getLogName());
                }
            }
            return true;
        }
        return false;
    }

    public WildEvocationEffect copy() {
        return new WildEvocationEffect(this);
    }
}

