/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainControlTargetEffect;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class WildMammothEffect
extends OneShotEffect {
    WildMammothEffect() {
        super(Outcome.GainControl);
        this.staticText = "if a player controls more creatures than each other player, the player who controls the most creatures gains control of {this}";
    }

    private WildMammothEffect(WildMammothEffect effect) {
        super((OneShotEffect)effect);
    }

    public WildMammothEffect copy() {
        return new WildMammothEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Permanent sourcePermanent = game.getPermanent(source.getSourceId());
            if (sourcePermanent != null) {
                int value;
                Player player;
                Player newController = null;
                int maxCreatures = 0;
                boolean tie = false;
                FilterPermanent filter = new FilterPermanent();
                filter.add((Predicate)CardType.CREATURE.getPredicate());
                for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
                    player = game.getPlayer(playerId);
                    if (player == null || (value = game.getBattlefield().countAll(filter, playerId, game)) <= maxCreatures) continue;
                    maxCreatures = value;
                }
                for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
                    player = game.getPlayer(playerId);
                    if (player == null || (value = game.getBattlefield().countAll(filter, playerId, game)) != maxCreatures) continue;
                    if (newController == null) {
                        newController = player;
                        continue;
                    }
                    tie = true;
                    break;
                }
                if (!controller.equals(newController) && !tie && newController != null) {
                    GainControlTargetEffect effect = new GainControlTargetEffect(Duration.Custom, newController.getId());
                    effect.setTargetPointer((TargetPointer)new FixedTarget(sourcePermanent, game));
                    game.addEffect((ContinuousEffect)effect, source);
                }
            }
            return true;
        }
        return false;
    }
}

