/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class WildResearchEffect
extends OneShotEffect {
    protected final FilterCard filter;

    WildResearchEffect(FilterCard filter) {
        super(Outcome.DrawCard);
        this.staticText = "Search your library for an " + filter.getMessage() + " and reveal that card. Put it into your hand, then discard a card at random. Then shuffle.";
        this.filter = filter;
    }

    private WildResearchEffect(WildResearchEffect effect) {
        super((OneShotEffect)effect);
        this.filter = effect.filter;
    }

    public WildResearchEffect copy() {
        return new WildResearchEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        TargetCardInLibrary target = new TargetCardInLibrary(this.filter);
        controller.searchLibrary(target, source, game);
        Card card = controller.getLibrary().getCard(target.getFirstTarget(), game);
        if (card != null) {
            controller.revealCards(source, (Cards)new CardsImpl(card), game);
            controller.moveCards(card, Zone.HAND, source, game);
        }
        controller.discardOne(true, false, source, game);
        controller.shuffleLibrary(source, game);
        return true;
    }
}

