/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class WildShapeEffect
extends ContinuousEffectImpl {
    private final int power;
    private final int toughness;
    private final SubType subType;
    private final Ability ability;

    WildShapeEffect(int power, int toughness, SubType subType, Ability ability) {
        super(Duration.EndOfTurn, Outcome.Benefit);
        this.power = power;
        this.toughness = toughness;
        this.subType = subType;
        this.ability = ability;
        this.staticText = power + "/" + toughness + " " + subType.getDescription() + " with " + ability.getRule();
    }

    private WildShapeEffect(WildShapeEffect effect) {
        super((ContinuousEffectImpl)effect);
        this.power = effect.power;
        this.toughness = effect.toughness;
        this.subType = effect.subType;
        this.ability = effect.ability;
    }

    public WildShapeEffect copy() {
        return new WildShapeEffect(this);
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            this.discard();
            return false;
        }
        switch (layer) {
            case TypeChangingEffects_4: {
                permanent.removeAllCreatureTypes(game);
                permanent.addSubType(game, new SubType[]{SubType.HUMAN});
                return true;
            }
            case AbilityAddingRemovingEffects_6: {
                permanent.addAbility(this.ability, source.getSourceId(), game);
                return true;
            }
            case PTChangingEffects_7: {
                if (sublayer != SubLayer.SetPT_7b) break;
                permanent.getPower().setModifiedBaseValue(this.power);
                permanent.getToughness().setModifiedBaseValue(this.toughness);
                return true;
            }
        }
        return false;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean hasLayer(Layer layer) {
        switch (layer) {
            case TypeChangingEffects_4: 
            case AbilityAddingRemovingEffects_6: 
            case PTChangingEffects_7: {
                return true;
            }
        }
        return false;
    }
}

