/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.util.RandomUtil;

class WildSwingEffect
extends OneShotEffect {
    WildSwingEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Choose three target nonenchantment permanents. Destroy one of them at random";
    }

    private WildSwingEffect(WildSwingEffect effect) {
        super((OneShotEffect)effect);
    }

    public WildSwingEffect copy() {
        return new WildSwingEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Target target;
        MageObject sourceObject = source.getSourceObject(game);
        if (!source.getTargets().isEmpty() && sourceObject != null && (target = (Target)source.getTargets().get(0)) != null && !target.getTargets().isEmpty()) {
            Permanent targetPermanent = game.getPermanent((UUID)target.getTargets().get(RandomUtil.nextInt((int)target.getTargets().size())));
            if (targetPermanent != null) {
                game.informPlayers(sourceObject.getLogName() + ": The randomly chosen target to destroy is " + targetPermanent.getLogName());
                targetPermanent.destroy(source, game, false);
            }
            return true;
        }
        return false;
    }
}

