/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.players.Player;

class WildbornPreserverCreateReflexiveTriggerEffect
extends OneShotEffect {
    WildbornPreserverCreateReflexiveTriggerEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may pay {X}. When you do, put X +1/+1 counters on {this}";
    }

    private WildbornPreserverCreateReflexiveTriggerEffect(WildbornPreserverCreateReflexiveTriggerEffect effect) {
        super((OneShotEffect)effect);
    }

    public WildbornPreserverCreateReflexiveTriggerEffect copy() {
        return new WildbornPreserverCreateReflexiveTriggerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        ManaCostsImpl cost = new ManaCostsImpl("{X}");
        if (player == null) {
            return false;
        }
        if (!player.chooseUse(this.outcome, "Pay " + cost.getText() + "?", source, game)) {
            return false;
        }
        int costX = player.announceX(0, Integer.MAX_VALUE, "Announce the value for {X} (pay for counters)", game, source, true);
        cost.add((Object)new GenericManaCost(costX));
        if (!cost.pay(source, game, source, source.getControllerId(), false, null)) {
            return false;
        }
        game.fireReflexiveTriggeredAbility(new ReflexiveTriggeredAbility((Effect)new AddCountersSourceEffect(CounterType.P1P1.createInstance(costX)), false, "put X +1/+1 counters on {this}"), source);
        return true;
    }
}

