/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.abilities.effects.keyword.ManifestEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class WildcallEffect
extends OneShotEffect {
    WildcallEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Manifest the top card of your library, then put X +1/+1 counters on it";
    }

    private WildcallEffect(WildcallEffect effect) {
        super((OneShotEffect)effect);
    }

    public WildcallEffect copy() {
        return new WildcallEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Card card = controller.getLibrary().getFromTop(game);
            if (card != null) {
                new ManifestEffect(1).apply(game, source);
                int xValue = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
                if (xValue > 0) {
                    AddCountersTargetEffect effect = new AddCountersTargetEffect(CounterType.P1P1.createInstance(xValue));
                    effect.setTargetPointer((TargetPointer)new FixedTarget(card.getId()));
                    return effect.apply(game, source);
                }
            }
            return true;
        }
        return false;
    }
}

