/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.UUID;
import mage.ApprovingObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.players.PlayerList;
import mage.target.TargetCard;
import mage.target.common.TargetCardInGraveyard;
import mage.util.RandomUtil;

class WildfireDevilsEffect
extends OneShotEffect {
    WildfireDevilsEffect() {
        super(Outcome.Neutral);
        this.staticText = "choose a player at random. That player exiles an instant or sorcery card from their graveyard. Copy that card. You may cast the copy without paying its mana cost.";
    }

    private WildfireDevilsEffect(WildfireDevilsEffect effect) {
        super((OneShotEffect)effect);
    }

    public WildfireDevilsEffect copy() {
        return new WildfireDevilsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        PlayerList players = game.getState().getPlayersInRange(controller.getId(), game);
        if (players == null) {
            return false;
        }
        Player randomPlayer = game.getPlayer((UUID)players.get(RandomUtil.nextInt((int)players.size())));
        if (randomPlayer == null) {
            return false;
        }
        game.informPlayers("The chosen random player is " + randomPlayer.getLogName());
        if (randomPlayer.getGraveyard().getCards(game).stream().noneMatch(card1 -> card1.isInstantOrSorcery(game))) {
            return false;
        }
        TargetCardInGraveyard targetCard = new TargetCardInGraveyard((FilterCard)StaticFilters.FILTER_CARD_INSTANT_OR_SORCERY);
        targetCard.withNotTarget(true);
        if (!randomPlayer.choose(Outcome.Discard, (Cards)randomPlayer.getGraveyard(), (TargetCard)targetCard, source, game)) {
            return false;
        }
        Card card = game.getCard(targetCard.getFirstTarget());
        if (card == null) {
            return false;
        }
        randomPlayer.moveCards(card, Zone.EXILED, source, game);
        if (game.getState().getZone(card.getId()) != Zone.EXILED) {
            return false;
        }
        Card copiedCard = game.copyCard(card, source, controller.getId());
        if (copiedCard == null) {
            return false;
        }
        if (!controller.chooseUse(this.outcome, "Cast the copy of the exiled card?", source, game)) {
            return false;
        }
        game.getState().setValue("PlayFromNotOwnHandZone" + copiedCard.getId(), (Object)Boolean.TRUE);
        Boolean cardWasCast = controller.cast(controller.chooseAbilityForCast(copiedCard, game, true), game, true, new ApprovingObject(source, game));
        game.getState().setValue("PlayFromNotOwnHandZone" + copiedCard.getId(), null);
        return cardWasCast;
    }
}

