/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class WildwoodScourgeTriggeredAbility
extends TriggeredAbilityImpl {
    WildwoodScourgeTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new AddCountersSourceEffect(CounterType.P1P1.createInstance()), false);
    }

    private WildwoodScourgeTriggeredAbility(WildwoodScourgeTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public WildwoodScourgeTriggeredAbility copy() {
        return new WildwoodScourgeTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.COUNTERS_ADDED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (event.getData().equals(CounterType.P1P1.getName())) {
            Permanent permanent = game.getPermanentOrLKIBattlefield(event.getTargetId());
            if (permanent == null) {
                permanent = game.getPermanentEntering(event.getTargetId());
            }
            return permanent != null && !event.getTargetId().equals(this.getSourceId()) && permanent.isCreature(game) && !permanent.hasSubtype(SubType.HYDRA, game) && permanent.isControlledBy(this.getControllerId());
        }
        return false;
    }

    public String getRule() {
        return "Whenever one or more +1/+1 counters are put on another non-Hydra creature you control, put a +1/+1 counter on {this}.";
    }
}

