/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class WillOfTheAllHunterEffect
extends OneShotEffect {
    WillOfTheAllHunterEffect() {
        super(Outcome.Benefit);
        this.staticText = "Target creature gets +2/+2 until end of turn. If it's blocking, instead put two +1/+1 counters on it.";
    }

    private WillOfTheAllHunterEffect(WillOfTheAllHunterEffect effect) {
        super((OneShotEffect)effect);
    }

    public WillOfTheAllHunterEffect copy() {
        return new WillOfTheAllHunterEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        if (permanent.getBlocking() > 0) {
            return permanent.addCounters(CounterType.P1P1.createInstance(2), source.getControllerId(), source, game);
        }
        game.addEffect((ContinuousEffect)new BoostTargetEffect(2, 2), source);
        return true;
    }
}

