/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class WindsOfAbandonOverloadEffect
extends OneShotEffect {
    WindsOfAbandonOverloadEffect() {
        super(Outcome.Exile);
        this.staticText = "Exile each creature you don't control. For each creature exiled this way, its controller searches their library for a basic land card. Those players put those cards onto the battlefield tapped, then shuffle.";
    }

    private WindsOfAbandonOverloadEffect(WindsOfAbandonOverloadEffect effect) {
        super((OneShotEffect)effect);
    }

    public WindsOfAbandonOverloadEffect copy() {
        return new WindsOfAbandonOverloadEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        HashMap<UUID, Integer> playerAmount = new HashMap<UUID, Integer>();
        CardsImpl cards = new CardsImpl();
        for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_CREATURE_YOU_DONT_CONTROL, source.getControllerId(), source, game)) {
            playerAmount.merge(permanent.getControllerId(), 1, Integer::sum);
            cards.add((Card)permanent);
        }
        if (!controller.moveCards((Cards)cards, Zone.EXILED, source, game)) {
            return true;
        }
        game.processAction();
        for (Map.Entry entry : playerAmount.entrySet()) {
            Player player = game.getPlayer((UUID)entry.getKey());
            if (player == null) continue;
            TargetCardInLibrary target = new TargetCardInLibrary(0, ((Integer)entry.getValue()).intValue(), (FilterCard)((Integer)entry.getValue() > 1 ? StaticFilters.FILTER_CARD_BASIC_LANDS : StaticFilters.FILTER_CARD_BASIC_LAND));
            if (player.searchLibrary(target, source, game) && !target.getTargets().isEmpty()) {
                player.moveCards(new CardsImpl((Collection)target.getTargets()).getCards(game), Zone.BATTLEFIELD, source, game, true, false, false, null);
            }
            player.shuffleLibrary(source, game);
        }
        return true;
    }
}

