/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.FlyingAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class WingedTempleOfOrazcaEffect
extends OneShotEffect {
    WingedTempleOfOrazcaEffect() {
        super(Outcome.Benefit);
        this.staticText = "target creature you control gains flying and gets +X/+X until end of turn, where X is its power";
    }

    private WingedTempleOfOrazcaEffect(WingedTempleOfOrazcaEffect effect) {
        super((OneShotEffect)effect);
    }

    public WingedTempleOfOrazcaEffect copy() {
        return new WingedTempleOfOrazcaEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent creature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (creature != null && creature.isCreature(game)) {
            int pow = creature.getPower().getValue();
            BoostTargetEffect effect = new BoostTargetEffect(pow, pow, Duration.EndOfTurn);
            effect.setTargetPointer((TargetPointer)new FixedTarget(creature, game));
            game.addEffect((ContinuousEffect)effect, source);
            effect = new GainAbilityTargetEffect((Ability)FlyingAbility.getInstance(), Duration.EndOfTurn);
            effect.setTargetPointer((TargetPointer)new FixedTarget(creature, game));
            game.addEffect((ContinuousEffect)effect, source);
        }
        return true;
    }
}

