/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.SacrificeTargetEffect;
import mage.abilities.effects.common.combat.CantBeBlockedTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class WingsOfHubrisEffect
extends OneShotEffect {
    WingsOfHubrisEffect() {
        super(Outcome.Detriment);
        this.staticText = "Equipped creature can't be blocked this turn. Sacrifice it at the beginning of the next end step";
    }

    private WingsOfHubrisEffect(WingsOfHubrisEffect effect) {
        super((OneShotEffect)effect);
    }

    public WingsOfHubrisEffect copy() {
        return new WingsOfHubrisEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        MageObject equipment = game.getLastKnownInformation(source.getSourceId(), Zone.BATTLEFIELD);
        if (equipment instanceof Permanent && ((Permanent)equipment).getAttachedTo() != null) {
            Permanent attachedToCreature = game.getPermanent(((Permanent)equipment).getAttachedTo());
            if (attachedToCreature != null) {
                CantBeBlockedTargetEffect effect = new CantBeBlockedTargetEffect(Duration.EndOfTurn);
                effect.setTargetPointer((TargetPointer)new FixedTarget(attachedToCreature, game));
                game.addEffect((ContinuousEffect)effect, source);
                SacrificeTargetEffect sacrificeEffect = new SacrificeTargetEffect("sacrifice this", source.getControllerId());
                sacrificeEffect.setTargetPointer((TargetPointer)new FixedTarget(attachedToCreature, game));
                AtTheBeginOfNextEndStepDelayedTriggeredAbility delayedAbility = new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)sacrificeEffect);
                game.addDelayedTriggeredAbility((DelayedTriggeredAbility)delayedAbility, source);
            }
            return true;
        }
        return false;
    }
}

