/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.IndestructibleAbility;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInLibrary;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class WinotaJoinerOfForcesEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCreatureCard("Human creature card");

    WinotaJoinerOfForcesEffect() {
        super(Outcome.Benefit);
        this.staticText = "look at the top six cards of your library. You may put a Human creature card from among them onto the battlefield tapped and attacking. It gains indestructible until end of turn. Put the rest of the cards on the bottom of your library in a random order.";
    }

    private WinotaJoinerOfForcesEffect(WinotaJoinerOfForcesEffect effect) {
        super((OneShotEffect)effect);
    }

    public WinotaJoinerOfForcesEffect copy() {
        return new WinotaJoinerOfForcesEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, 6));
        TargetCardInLibrary targetCardInLibrary = new TargetCardInLibrary(0, 1, filter);
        player.choose(this.outcome, (Cards)cards, (TargetCard)targetCardInLibrary, source, game);
        Card card = game.getCard(targetCardInLibrary.getFirstTarget());
        if (card == null || !player.moveCards(card, Zone.BATTLEFIELD, source, game, true, false, true, null)) {
            return player.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
        }
        Permanent permanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game);
        if (permanent == null) {
            return player.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
        }
        game.getCombat().addAttackingCreature(permanent.getId(), game);
        cards.remove(card);
        game.addEffect(new GainAbilityTargetEffect((Ability)IndestructibleAbility.getInstance(), Duration.EndOfTurn).setTargetPointer((TargetPointer)new FixedTarget(permanent, game)), source);
        return player.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
    }

    static {
        filter.add((Predicate)SubType.HUMAN.getPredicate());
    }
}

