/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.ExileXFromYourGraveCost;
import mage.abilities.costs.common.PayLifeCost;
import mage.abilities.costs.common.TapSourceCost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.GetXValue;
import mage.abilities.dynamicvalue.common.SignInversionDynamicValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.BoostAllEffect;
import mage.abilities.effects.common.continuous.GainAbilityAllEffect;
import mage.abilities.keyword.ExhaustAbility;
import mage.abilities.keyword.WardAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.constants.SuperType;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.util.CardUtil;

public final class WinterCursedRider
extends CardImpl {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent("Each other nonartifact creature");
    private static final DynamicValue xValue = new SignInversionDynamicValue((DynamicValue)GetXValue.instance);

    public WinterCursedRider(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.CREATURE}, "{U}{B}");
        this.supertype.add(SuperType.LEGENDARY);
        this.subtype.add((Object)SubType.HUMAN);
        this.subtype.add((Object)SubType.WARLOCK);
        this.power = new MageInt(3);
        this.toughness = new MageInt(2);
        this.addAbility((Ability)new WardAbility((Cost)new PayLifeCost(2)));
        WardAbility wardAbility = new WardAbility((Cost)new PayLifeCost(2));
        this.addAbility((Ability)new SimpleStaticAbility((Effect)new GainAbilityAllEffect((Ability)wardAbility, Duration.WhileOnBattlefield, (FilterPermanent)StaticFilters.FILTER_CONTROLLED_PERMANENT_ARTIFACTS).setText("Artifacts you control have \"" + CardUtil.getTextWithFirstCharUpperCase((String)wardAbility.getRuleWithoutHint()) + "\"")));
        ExhaustAbility ability = new ExhaustAbility((Effect)new BoostAllEffect(xValue, xValue, Duration.EndOfTurn, filter, true), (Cost)new ManaCostsImpl("{2}{U}{B}"));
        ability.addCost((Cost)new TapSourceCost());
        ability.addCost((Cost)new ExileXFromYourGraveCost((FilterCard)StaticFilters.FILTER_CARD_ARTIFACTS).setText("Exile X artifact cards from your graveyard"));
        this.addAbility((Ability)ability);
    }

    private WinterCursedRider(WinterCursedRider card) {
        super((CardImpl)card);
    }

    public WinterCursedRider copy() {
        return new WinterCursedRider(this);
    }

    static {
        filter.add(Predicates.not((Predicate)CardType.ARTIFACT.getPredicate()));
    }
}

