/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainControlTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetOpponent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class WishclawTalismanEffect
extends OneShotEffect {
    WishclawTalismanEffect() {
        super(Outcome.Benefit);
        this.staticText = "An opponent gains control of {this}";
    }

    private WishclawTalismanEffect(WishclawTalismanEffect effect) {
        super((OneShotEffect)effect);
    }

    public WishclawTalismanEffect copy() {
        return new WishclawTalismanEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetOpponent target = new TargetOpponent();
        target.withNotTarget(true);
        if (!player.choose(this.outcome, (Target)target, source, game)) {
            return false;
        }
        GainControlTargetEffect continuousEffect = new GainControlTargetEffect(Duration.Custom, true, target.getFirstTarget());
        continuousEffect.setTargetPointer((TargetPointer)new FixedTarget(source.getSourceId(), game));
        game.addEffect((ContinuousEffect)continuousEffect, source);
        return true;
    }
}

