/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostAllEffect;
import mage.choices.Choice;
import mage.choices.ChoiceCreatureType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.players.Player;

class WitchsVengeanceEffect
extends OneShotEffect {
    WitchsVengeanceEffect() {
        super(Outcome.Benefit);
        this.staticText = "Creatures of the creature type of your choice get -3/-3 until end of turn.";
    }

    private WitchsVengeanceEffect(WitchsVengeanceEffect effect) {
        super((OneShotEffect)effect);
    }

    public WitchsVengeanceEffect copy() {
        return new WitchsVengeanceEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        ChoiceCreatureType choice = new ChoiceCreatureType(game, source);
        if (!player.choose(this.outcome, (Choice)choice, game)) {
            return false;
        }
        FilterCreaturePermanent filter = new FilterCreaturePermanent();
        filter.add((Predicate)SubType.byDescription((String)choice.getChoiceKey()).getPredicate());
        game.addEffect((ContinuousEffect)new BoostAllEffect(-3, -3, Duration.EndOfTurn, filter, false), source);
        return true;
    }
}

