/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.HashSet;
import java.util.UUID;
import mage.ApprovingObject;
import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.costs.mana.ManaCosts;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.ExileZone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class WizardsSpellbookEffect
extends OneShotEffect {
    private final int level;

    WizardsSpellbookEffect(int level) {
        super(Outcome.Benefit);
        this.level = level;
        switch (level) {
            case 1: {
                this.staticText = "copy that card. You may cast the copy";
                break;
            }
            case 2: {
                this.staticText = "copy that card. You may cast the copy by paying {1} rather than paying its mana cost";
                break;
            }
            case 3: {
                this.staticText = "copy each card exiled with {this}. You may cast any number of the copies without paying their mana costs";
                break;
            }
            default: {
                throw new IllegalArgumentException("Level must be 1-3");
            }
        }
    }

    private WizardsSpellbookEffect(WizardsSpellbookEffect effect) {
        super((OneShotEffect)effect);
        this.level = effect.level;
    }

    public WizardsSpellbookEffect copy() {
        return new WizardsSpellbookEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (player == null || card == null) {
            return false;
        }
        UUID exileId = CardUtil.getExileZoneId((Game)game, (Ability)source);
        player.moveCardsToExile(card, source, game, true, exileId, CardUtil.getSourceName((Game)game, (Ability)source));
        if (this.level < 3) {
            Card copiedCard = game.copyCard(card, source, source.getControllerId());
            if (!player.chooseUse(Outcome.Benefit, "Cast " + copiedCard.getName() + (this.level == 1 ? "?" : " by paying {1}?"), source, game)) {
                return false;
            }
            SpellAbility spellAbility = player.chooseAbilityForCast(copiedCard, game, this.level == 2);
            if (spellAbility == null) {
                return false;
            }
            game.getState().setValue("PlayFromNotOwnHandZone" + copiedCard.getId(), (Object)Boolean.TRUE);
            if (this.level == 2) {
                player.setCastSourceIdWithAlternateMana(copiedCard.getId(), (ManaCosts)new ManaCostsImpl("{1}"), null);
            }
            player.cast(spellAbility, game, false, new ApprovingObject(source, game));
            game.getState().setValue("PlayFromNotOwnHandZone" + copiedCard.getId(), null);
            return true;
        }
        ExileZone exile = game.getExile().getExileZone(exileId);
        if (exile == null || exile.isEmpty()) {
            return true;
        }
        HashSet<Card> cards = new HashSet<Card>();
        for (Card exiledCard : exile.getCards(game)) {
            cards.add(game.copyCard(exiledCard, source, source.getControllerId()));
        }
        while (!cards.isEmpty()) {
            for (Card copiedCard : cards) {
                if (!player.chooseUse(Outcome.PlayForFree, "Cast " + copiedCard.getName() + " without paying its mana cost?", source, game)) continue;
                game.getState().setValue("PlayFromNotOwnHandZone" + copiedCard.getId(), (Object)Boolean.TRUE);
                player.cast(player.chooseAbilityForCast(copiedCard, game, true), game, true, new ApprovingObject(source, game));
                game.getState().setValue("PlayFromNotOwnHandZone" + copiedCard.getId(), null);
            }
            if (!player.chooseUse(Outcome.Neutral, "Continue casting exiled cards?", source, game)) break;
            cards.removeIf(c -> game.getState().getZone(c.getId()) != Zone.EXILED);
        }
        return true;
    }
}

