/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.Token;
import mage.game.permanent.token.WolfToken;
import mage.players.Player;

class WolfcallersHowlEffect
extends OneShotEffect {
    WolfcallersHowlEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "create X 2/2 green Wolf creature tokens, where X is the number of your opponents with four or more cards in hand";
    }

    private WolfcallersHowlEffect(WolfcallersHowlEffect effect) {
        super((OneShotEffect)effect);
    }

    public WolfcallersHowlEffect copy() {
        return new WolfcallersHowlEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            int count = 0;
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                Player opponent;
                if (!controller.hasOpponent(playerId, game) || (opponent = game.getPlayer(playerId)) == null || opponent.getHand().size() < 4) continue;
                ++count;
            }
            if (count > 0) {
                return new CreateTokenEffect((Token)new WolfToken(), count).apply(game, source);
            }
            return true;
        }
        return false;
    }
}

