/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.SourcePermanentPowerValue;
import mage.abilities.dynamicvalue.common.SourcePermanentToughnessValue;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BecomesCreatureTargetEffect;
import mage.abilities.keyword.HasteAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.token.Token;
import mage.game.permanent.token.custom.CreatureToken;

class WoodcallerAutomatonEffect
extends OneShotEffect {
    WoodcallerAutomatonEffect() {
        super(Outcome.Benefit);
        this.staticText = "It becomes a Treefolk creature with haste and base power and toughness equal to {this}'s power and toughness. It's still a land";
    }

    private WoodcallerAutomatonEffect(WoodcallerAutomatonEffect effect) {
        super((OneShotEffect)effect);
    }

    public WoodcallerAutomatonEffect copy() {
        return new WoodcallerAutomatonEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int power = SourcePermanentPowerValue.ALLOW_NEGATIVE.calculate(game, source, (Effect)this);
        int toughness = SourcePermanentToughnessValue.instance.calculate(game, source, (Effect)this);
        game.addEffect((ContinuousEffect)new BecomesCreatureTargetEffect((Token)new CreatureToken(power, toughness, "", new SubType[]{SubType.TREEFOLK}).withAbility((Ability)HasteAbility.getInstance()), false, true, Duration.Custom), source);
        return true;
    }
}

