/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DestroyTargetEffect;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class WoodenStakeBlocksOrBecomesBlockedTriggeredAbility
extends TriggeredAbilityImpl {
    WoodenStakeBlocksOrBecomesBlockedTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DestroyTargetEffect(true), false);
    }

    private WoodenStakeBlocksOrBecomesBlockedTriggeredAbility(WoodenStakeBlocksOrBecomesBlockedTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.BLOCKER_DECLARED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent equipment = game.getPermanent(this.sourceId);
        if (equipment != null && equipment.getAttachedTo() != null) {
            if (event.getSourceId().equals(equipment.getAttachedTo())) {
                Permanent blocks = game.getPermanent(event.getTargetId());
                if (blocks != null && blocks.hasSubtype(SubType.VAMPIRE, game)) {
                    for (Effect effect : this.getEffects()) {
                        effect.setTargetPointer((TargetPointer)new FixedTarget(event.getTargetId(), game));
                    }
                    return true;
                }
                return false;
            }
            if (event.getTargetId().equals(equipment.getAttachedTo())) {
                Permanent blockedBy = game.getPermanent(event.getSourceId());
                if (blockedBy != null && blockedBy.hasSubtype(SubType.VAMPIRE, game)) {
                    for (Effect effect : this.getEffects()) {
                        effect.setTargetPointer((TargetPointer)new FixedTarget(event.getSourceId(), game));
                    }
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    public String getRule() {
        return "Whenever equipped creature blocks or becomes blocked by a Vampire, destroy that creature. It can't be regenerated.";
    }

    public WoodenStakeBlocksOrBecomesBlockedTriggeredAbility copy() {
        return new WoodenStakeBlocksOrBecomesBlockedTriggeredAbility(this);
    }
}

