/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.constants.WatcherScope;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.watchers.Watcher;

class WookieeMysticWatcher
extends Watcher {
    private Ability source;
    private List<UUID> creatures = new ArrayList<UUID>();

    public WookieeMysticWatcher() {
        super(WatcherScope.CARD);
    }

    Watcher withParams(Ability source) {
        this.source = source;
        return this;
    }

    public void watch(GameEvent event, Game game) {
        ZoneChangeEvent zEvent;
        if (event.getType() == GameEvent.EventType.MANA_PAID) {
            MageObject target = game.getObject(event.getTargetId());
            if (event.getSourceId() != null && event.getSourceId().equals(this.getSourceId()) && target != null && target.isCreature(game) && event.getFlag() && target instanceof Spell) {
                this.creatures.add(((Spell)target).getCard().getId());
            }
        }
        if (event.getType() == GameEvent.EventType.COUNTERED && this.creatures.contains(event.getTargetId())) {
            this.creatures.remove(event.getSourceId());
        }
        if (event.getType() == GameEvent.EventType.ZONE_CHANGE && this.creatures.contains(event.getSourceId()) && (zEvent = (ZoneChangeEvent)event).getToZone() == Zone.STACK) {
            this.creatures.remove(event.getSourceId());
        }
        if (event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD && this.creatures.contains(event.getSourceId())) {
            Permanent creature = game.getPermanent(event.getSourceId());
            creature.addCounters(CounterType.P1P1.createInstance(), this.source.getControllerId(), this.source, game);
            this.creatures.remove(event.getSourceId());
        }
    }

    public void reset() {
        super.reset();
        this.creatures.clear();
    }
}

